// CS373 Stiefvater
// Kevin Goodier kgoodier@iname.com
// 4/7/99
//
// Image holder class

#if !defined (IMAGE_C)
#define IMAGE_C

#include <stdio.h>
#include "Image.h"

Image::Image(void) :
    cols_(0),
    rows_(0),
    maxval_(255),
    pixels_(0)
{
    pixel p = {0, 0, 0};
    fill(p);
}

Image::Image(int cols, int rows) :
    cols_(cols),
    rows_(rows),
    maxval_(255),
    pixels_(ppm_allocarray(cols, rows))
{
    pixel p = {0, 0, 0};
    fill(p);
}

Image::Image(char *ppm_filename) :
    pixels_(0)
{
    read_ppm(ppm_filename);
}

void
Image::operator= (const Image & img)
{
    if (&img == this)
	return;
    else {
	if (rows_ > 0)
	    ppm_freearray(pixels_, rows_);
	cols_ = img.cols_;
	rows_ = img.rows_;
	maxval_ = maxval_;
	for (int row = 0; row < rows_; row++) {
	    for (int col = 0; col < cols_; col++) {
		pixels_[row][col] = img.pixels_[row][col];
	    }
	}
    }
}

Image::~Image(void) 
{
    if (rows_ > 0)
	ppm_freearray(pixels_, rows_);
}

int
Image::getWidth(void)
{
    return cols_;
}

int
Image::getHeight(void)
{
    return rows_;
}

void
Image::fill(pixel c)
{
    for (int row = 0; row < rows_; row++) {
	for (int col = 0; col < cols_; col++) {
	    pixels_[row][col] = c;
	}
    }
}

void
Image::erase(void)
{
    pixel c = {0, 0, 0};
    fill(c);
}   

int
Image::write_ppm(char *ppm_filename)
{
    FILE *f = fopen(ppm_filename, "w");
    if (f != 0) {
	ppm_writeppm(f, pixels_, cols_, rows_, maxval_, 0);
	fclose(f);
	return 1;
    }
    return 0;
}

int
Image::read_ppm(char *ppm_filename)
{
    FILE *f = fopen(ppm_filename, "r");
    if (f != 0) {
	pixels_ = ppm_readppm(f, &cols_, &rows_, &maxval_);
	fclose(f);
	if (pixels_ == 0) {
	    return 0; // fail!
	}
	return 1;
    }
    return 0;
}

#endif  /* IMAGE_C */
