/* -*- C++ -*- */
// CS373 Stiefvater
// Kevin Goodier kgoodier@iname.com
// 5/6/99
//
// Image class handles manipulation of weird PNM files
//
// Updated 10/11/00 for Computational Art
//
// bkg2

#if !defined (IMAGE_H)
#define IMAGE_H

extern "C" {
#include <ppm.h>
}


class Image
{
public:
    Image(void);
    Image(int cols, int rows);
    Image(char *ppm_filename);
    void operator= (const Image & img);
    ~Image(void);

    int getWidth(void);
    int getHeight(void);
    void fill(pixel c);  // fill image with color c
    void erase(void);  // fills image with black
    int write_ppm(char *ppm_filename);
    int read_ppm(char *ppm_filename);
    
    int cols_, rows_;
    pixval maxval_;
    pixel **pixels_;
};

#endif /* IMAGE_H */


