#include "Mesh.h"
#include "Circle.h"
#include "../Options.h"
#include <math.h>

Circle::Circle()
{
}

Circle::Circle(float x1, float y1, float z1, float radius) :
  Mesh(x1, y1, z1),
  counter_(0)
{
	SetScale(radius, radius, 1);
  swaytime_ = (rand() % 40) / 10 + 3;
  maxsway_ = (rand() % 50) / 150.0;

#define N 8
#define PI2N (PI2/N)

  Vertex *v_array[N];
  for (int n = 0; n < N; n++) {
    v_array[n] = new Vertex(cos(n * PI2N), sin(n * PI2N), 0);
  }
  Edge *e_head = new Edge(v_array[0], v_array[1]);
  Edge *e_prev = e_head;
  for (n = 1; n < N; n++) {
    e_prev = new Edge(v_array[n], v_array[(n+1) % N], e_prev);
  }
  Face *face = new Face(e_head, N);
  faces_.push_back(face);
}


Circle::~Circle()
{
}

int 
Circle::Draw(void)
{
	glPushMatrix();
	glDisable(GL_TEXTURE_2D);  // stop using texture objects
	glTranslatef(p_.x, p_.y, p_.z);
	glScalef(s_.x, s_.x, s_.x);
	glRotatef(r_.x, 1.0f, 0.0, 0.0);
	glRotatef(r_.y, 0.0, 1.0f, 0.0);
	glRotatef(r_.z, 0.0, 0.0, 1.0f);
  if (b_selected_) {
    glColor3f(c_.x * HIGHLIGHT_SCALE, c_.y * HIGHLIGHT_SCALE, c_.z * HIGHLIGHT_SCALE);	  
  }
  else {
	  glColor3f(c_.x, c_.y, c_.z);	
  }
  faces_[0]->Draw();
  glPopMatrix();

#if 0
  if (b_selected_) {
   	glEnable(GL_POLYGON_OFFSET_FILL);
  	glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
  	glPolygonOffset(-1.0, -1.0);
  	glColor3f(1.0, 1.0, 1.0);
  	glutSolidSphere(1.0, 8, 4);
  	glDisable(GL_POLYGON_OFFSET_FILL);
  	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
    glColor3f(c_.x / 2, c_.y / 2, c_.z / 2);	  
  }
  else {
	  glColor3f(c_.x, c_.y, c_.z);	
  }
  glutSolidSphere(1.0, 8, 4);
	glPopMatrix();
#endif

	return ERR_OK;
}

void
Circle::Update(float timedelta)
{
  Mesh::Update(timedelta);
#ifndef DYNAMISM
  /* conflict of var names */
  counter_ += timedelta;
  if (counter_ > swaytime_) counter_ = 0;
  float ds = maxsway_ * sin(PI2 * counter_ / swaytime_);
  SetScale(ds + s_.x, ds + s_.y, 0);
#endif
}
