#include "../Options.h"
#include "Face.h"
#include <math.h>

Face::Face() :
  edges_(0),
  edges_size_(0)
{
}

Face::Face(Edge *edges, int edges_size) :
  edges_(edges),
  edges_size_(edges_size)
{
}

void
Face::Draw(void)
{
  Edge *e = edges_;
  Vertex *v;
  
  if (edges_size_ < 3) {
    return;
  }

  if (edges_size_ == 3) {
    glBegin(GL_TRIANGLES);
    for (int i = 0; i < edges_size_; i++) {
      v = e->v1_;
      glNormal3f(0.0, 0.0, 1.0);
      glVertex3f(v->p_.x, v->p_.y, v->p_.z);
      e = e->next_;
    }
    glEnd();
  }
  else if (edges_size_ == 4) {
    glBegin(GL_QUADS);
    for (int i = 0; i < edges_size_; i++) {
      v = e->v1_;
      glNormal3f(0.0, 0.0, 1.0);
      glVertex3f(v->p_.x, v->p_.y, v->p_.z);
      e = e->next_;
    }
    glEnd();
  }
  else {
    glBegin(GL_POLYGON);
    for (int i = 0; i < edges_size_; i++) {
      v = e->v1_;
      glNormal3f(0.0, 0.0, 1.0);
      glVertex3f(v->p_.x, v->p_.y, v->p_.z);
      e = e->next_;
    }
    glEnd();
  }
}

void
Face::Update(float timedelta)
{
  Edge *e = edges_;
  for (int i = 0; i < edges_size_; i++) {
    e->v1_->Update(timedelta);
    e = e->next_;
  }
}

void
Face::Merge(Face *f)
{

}

void 
Face::ChangePos(float dx, float dy, float dz)
{
  for (Edge *e = edges_; e != 0; e = e->next_) {
    e->v1_->ChangePos(dx, dy, dz);
  }
}

void
Face::ChangeRotate(float dx, float dy, float dz)
{
  for (Edge *e = edges_; e != 0; e = e->next_) {
    e->v1_->ChangeScale(dx, dy, dz);
  }
}

void 
Face::ChangeScale(float dx, float dy, float dz)
{
  for (Edge *e = edges_; e != 0; e = e->next_) {
    e->v1_->ChangeScale(dx, dy, dz);
  }
}

void 
Face::SetPos(float x, float y, float z)
{
  for (Edge *e = edges_; e != 0; e = e->next_) {
    e->v1_->SetPos(x, y, z);
  }
}

void 
Face::SetRotate(float x, float y, float z)
{
  for (Edge *e = edges_; e != 0; e = e->next_) {
    e->v1_->SetRotate(x, y, z);
  }
}

void 
Face::SetScale(float x, float y, float z)
{
  for (Edge *e = edges_; e != 0; e = e->next_) {
    e->v1_->SetScale(x, y, z);
  }
}

float
Face::GetArea(void)
{
  /* 
  * Triangle 
  * see http://www.geocities.com/CapeCanaveral/Launchpad/2426/page94.html 
  * c^2 = a^2 + b^2 - 2ab Cos C 
  * AREA = (1/2)(ab Sin C)
  */
  if (edges_size_ == 3) {
#if 0
    float height = abs(edges_->v1_->p_.y - edges_->v2_->p_.y);
    float width = abs(edges_->next_->v1_->p_.x - edges_->next_->v2_->p_.x);
    return (width * height / 2);
#else
    /* General case */
    float a = edges_->GetLength();
    float b = edges_->next_->GetLength();
    float c = edges_->next_->next_->GetLength();
    float temp = a * a + b * b - c * c;
    temp /= (2 * a * b);
    float C = acos(temp);
    return (a * b * sin(C) / 2);
#endif
  }
  /*
  * Square
  */
  else if (edges_size_ == 4) {
    float x = edges_->GetLength();
    float y = edges_->next_->GetLength();
    return (x * y);
  }
  else {
    return 1;
  }
}