#ifndef MESH_H
#define MESH_H

#include "Face.h"
#include "../struct.h"

class Mesh : public Vertex {
public:
  Mesh();
  Mesh(float x, float y, float z);
  virtual ~Mesh();

 	virtual int Draw(void);
	virtual void Update(float timedelta);

  virtual void Merge(Mesh *s);
  virtual void CreatePath(Mesh *s, float scale, float time);

#if 0 
  virtual void ChangePos(float dx, float dy, float dz);
  virtual void ChangeRotate(float dx, float dy, float dz);
  virtual void ChangeScale(float dx, float dy, float dz);
  virtual void SetPos(float x, float y, float z);
  virtual void SetRotate(float x, float y, float z);
  virtual void SetScale(float x, float y, float z);
#endif

  virtual float GetVolume(void);

	virtual void SelectMaterial(int i);
  virtual void SetName(const char *name);
  virtual void SetSelected(int pred);
  
  virtual const char* GetName(void);
  virtual int IsSelected(void) { return b_selected_; }

  std::vector<Face*> faces_;  // list of faces making up the mesh
	std::vector<MATERIAL> materials_;	// Holds one or more material definitions
	int				objid_;				    // unique id of object
	char			*objname_;	    	// name of object
	int       b_selected_;			// is this item currently selected?
  double    timestamp_;

	static void SetGlobalObjIDBase(int base);
	static int GLOBAL_OBJ_ID;

  enum COORD_INDICES { X = 0, Y = 1, Z = 2 };
	enum ERR_STATUS {
    ERR_FAIL = 0,
		ERR_OK = 1
	};

protected:
	void SetMaterial(int mode, float *f, float alpha);


};

#endif /* MESH_H */