#include "Mesh.h"
#include "Parallelogram.h"
#include "../Options.h"
#include <math.h>  // sin

Parallelogram::Parallelogram()
{
}

Parallelogram::Parallelogram(float x1, float y1, float z1, float dim) :
  Mesh(x1, y1, z1),
  counter_(0)
{
	SetScale(dim/2, dim/2, 1);
  swaytime_ = (rand() % 40) / 10 + 4;
  //maxsway_ = (rand() % 100) / 133 + 0.2;
  maxsway_ = (rand() % 50) / 10 + 2;

  Vertex *v1 = new Vertex(1.1, 0.8, 0);
  Vertex *v2 = new Vertex(-0.15, 0.8, 0);
  Vertex *v3 = new Vertex(-1.1, -0.8, 0);
  Vertex *v4 = new Vertex(0.15, -0.8, 0);
  Edge *e1 = new Edge(v1, v2);
  Edge *e2 = new Edge(v2, v3, e1);
  Edge *e3 = new Edge(v3, v4, e2);
  Edge *e4 = new Edge(v4, v1, e3);
  Face *face = new Face(e1, 4);
  faces_.push_back(face);
}


Parallelogram::~Parallelogram()
{
}

int 
Parallelogram::Draw(void)
{
	glPushMatrix();
  glDisable(GL_TEXTURE_2D);
	glTranslatef(p_.x, p_.y, p_.z);
	glScalef(s_.x, s_.x, s_.x);
	glRotatef(r_.x, 1.0f, 0.0, 0.0);
	glRotatef(r_.y, 0.0, 1.0f, 0.0);
	glRotatef(r_.z, 0.0, 0.0, 1.0f);
  if (b_selected_) {
    glColor3f(c_.x * HIGHLIGHT_SCALE, c_.y * HIGHLIGHT_SCALE, c_.z * HIGHLIGHT_SCALE);	  
  }
  else {
	  glColor3f(c_.x, c_.y, c_.z);	
  }
  faces_[0]->Draw();
  glPopMatrix();

	return ERR_OK;
}

void
Parallelogram::Update(float timedelta)
{
  Mesh::Update(timedelta);
#ifndef DYNAMISM
  /* conflict of var names */
  counter_ += timedelta;
  if (counter_ > swaytime_) counter_ = 0;
  SetRotate(0, 0, maxsway_ * sin(PI2 * counter_ / swaytime_));
#endif
}
