#ifndef VERTEX_H
#define VERTEX_H

#include "vector3f.h"
#include <vector>

#define EASE_THRESHOLD 0.7f

class Vertex;

struct WAYPOINT {
  Vertex *v;
  float time;
  int type;

  WAYPOINT () { v = 0; time = 0; type = 0; }
};

enum WAYPOINT_TYPE {
  WAYPOINT_EASE,
  WAYPOINT_LINEAR
};

class Vertex {
public:
	Vertex();
  Vertex(const Vertex &l);
  Vertex(float x, float y, float z);
	Vertex(float x, float y, float z, float mass);
	virtual ~Vertex();
  virtual void Reset(void);
  virtual void Update(float timedelta);
  virtual void ClearPath(void);
  virtual Vertex* Goto(float time, Vertex &v, int type = WAYPOINT_EASE);
  virtual Vertex* Goto(float time, float x, float y, float z, int type = WAYPOINT_EASE);
  virtual Vertex* Goto(float time, vector3f pos, int type = WAYPOINT_EASE);
  virtual Vertex* GotoRest(float time);
  virtual void GotoWaypoint(int path_idx);

  virtual void ChangePos(float dx, float dy, float dz) { p_.Change(dx, dy, dz); }
  virtual void ChangeRotate(float dx, float dy, float dz) { r_.Change(dx, dy, dz); }
  virtual void ChangeScale(float dx, float dy, float dz) { s_.x *= dx; s_.y *= dy; s_.z *= dz; }
  virtual void ChangeColor(float dx, float dy, float dz) { c_.Change(dx, dy, dz); }
  virtual void SetPos(float x, float y, float z) { p_.Set(x, y, z); }
  virtual void SetRotate(float x, float y, float z) { r_.Set(x, y, z); }
  virtual void SetScale(float x, float y, float z) { s_.Set(x, y, z); }
  virtual void SetColor(float x, float y, float z) { c_.Set(x, y, z); }

  vector3f p_;            /* Position */
  vector3f r_;            /* Rotation */
  vector3f s_;            /* Scaling */
  vector3f c_;            /* Color */
  vector3f dp_;           /* Delta position */
  vector3f dr_;           /* Delta rotation */
  vector3f ds_;           /* Delta scaling */
  vector3f dc_;           /* Delta color */
  vector3f velp_;         /* Velocity position */
  vector3f velr_;         /* Velocity rotation */
  vector3f vels_;         /* Velocity scaling */
  vector3f velc_;         /* Velocity color */
  vector3f accelp_;       /* Acceleration position */
  vector3f accelr_;       /* Acceleration rotation */
  vector3f accels_;       /* Acceleration scaling */
  vector3f accelc_;       /* Acceleration color */
	float mass_;

  /* "Home" location */
  vector3f restp_;        /* Rest position */
  vector3f restr_;        /* Rest rotation */
  vector3f rests_;        /* Rest scaling */
  vector3f restc_;        /* Rest color */

  /* Destination points */
  std::vector<WAYPOINT> path_;  /* Vertices on path */
  int path_idx_;
  
  enum PATH_TYPE {
    PATH_SINGLE,
    PATH_LOOP
  };
  int path_type_;

private:
  /* Timers */
  float counter_;
  float period_;

};

#endif /* VERTEX_H */