#include "Edge.h"
#include <math.h>

Edge::Edge() :
  v1_(0),
  v2_(0),
  prev_(0),
  next_(0)
{
}

Edge::Edge(Vertex *v1, Vertex *v2) :
  v1_(v1),
  v2_(v2),
  prev_(0),
  next_(0)
{
}

Edge::Edge(Vertex *v1, Vertex *v2, Edge *prev) :
  v1_(v1),
  v2_(v2),
  prev_(prev),
  next_(prev->next_)
{
  prev_->next_ = this;
  if (next_ != 0) {
    next_->prev_ = this;
  }
}

float
Edge::GetLength(void)
{
  float dx = v1_->p_.x - v2_->p_.x;
  float dy = v1_->p_.y - v2_->p_.y;
  float dz = v1_->p_.z - v2_->p_.z;
  return sqrt(dx * dx + dy * dy + dz * dz);
}
