#ifndef FACE_H
#define FACE_H

#include "Edge.h"
#include <vector>

class Face {
public:
  Face();
  Face(Edge *edges, int edges_size);

  void Draw(void);
  void Update(float timedelta);
  void Merge(Face *f);

  void ChangePos(float dx, float dy, float dz);
  void ChangeRotate(float dx, float dy, float dz);
  void ChangeScale(float dx, float dy, float dz);
  void SetPos(float x, float y, float z);
  void SetRotate(float x, float y, float z);
  void SetScale(float x, float y, float z);

  float GetArea(void);

  Edge *edges_;
  int edges_size_;
};

#endif /* FACE_H */