#include "../Options.h"
#include "Mesh.h"

int Mesh::GLOBAL_OBJ_ID = 1;

void 
Mesh::SetGlobalObjIDBase(int base) 
{
	Mesh::GLOBAL_OBJ_ID = base;
}

Mesh::Mesh() :
  Vertex(),
	objid_(GLOBAL_OBJ_ID++),
  b_selected_(0),
  objname_(0)
{
 	MATERIAL mat = {
		{0.0f,0.0f,0.0f},		/* ambient */
		{0.75f,0.75f,0.75f},	/* diffuse */
		{1.0f,1.0f,1.0f},		/* specular */
		{0.0f,0.0f,0.0f},		/* emission */
		1.0f					/* alpha */
	};
	materials_.push_back(mat);
  timestamp_ = Options::instance()->GetTime();
}

Mesh::Mesh(float x, float y, float z) :
  Vertex(x, y, z),
	objid_(GLOBAL_OBJ_ID++),
  b_selected_(0),
  objname_(0)
{
  timestamp_ = Options::instance()->GetTime();
}

Mesh::~Mesh()
{
}

int
Mesh::Draw(void) 
{

  for (int i = 0; i < faces_.size(); i++) {
    faces_[i]->Draw();
  }

  return ERR_OK;
}

void
Mesh::Update(float timedelta)
{
  Vertex::Update(timedelta);
  for (int i = 0; i < faces_.size(); i++) {
    faces_[i]->Update(timedelta);
  }
}

void
Mesh::Merge(Mesh *s)
{
  //float ratio = (GetVolume() + s->GetVolume()) / GetVolume();
  float ratio = 1.2;  // hack
  ChangeScale(ratio, ratio, 1);
  s->SetScale(s->s_.x / ratio, s->s_.y / ratio, 1);
  //faces_[0]->Merge(s->faces_[0]);
}

void
Mesh::CreatePath(Mesh *s, float scale, float time)
{
  vector3f p;
  Vertex *v;
  Edge *e;
  Face *f;
  f = s->faces_[0];
  float t = f->edges_size_ / time;
  for (e = f->edges_; e != 0; e = e->next_) {
    v = e->v1_;
    p = v->p_ * scale;
    Goto(t, p_.x + p.x, p_.y + p.y, p_.z);
  }
}

#if 0
void 
Mesh::ChangePos(float dx, float dy, float dz)
{
  Vertex::ChangePos(dx, dy, dz);
  for (int i = 0; i < faces_.size(); i++) {
    faces_[i]->ChangePos(dx, dy, dz);
  }
}

void
Mesh::ChangeRotate(float dx, float dy, float dz)
{
  Vertex::ChangeRotate(dx, dy, dz);
  for (int i = 0; i < faces_.size(); i++) {
    faces_[i]->ChangeRotate(dx, dy, dz);
  }
}

void 
Mesh::ChangeScale(float dx, float dy, float dz)
{
  Vertex::ChangeScale(dx, dy, dz);
  for (int i = 0; i < faces_.size(); i++) {
    faces_[i]->ChangeScale(dx, dy, dz);
  }
}

void 
Mesh::SetPos(float x, float y, float z)
{
  Vertex::SetPos(x, y, z);
  for (int i = 0; i < faces_.size(); i++) {
    faces_[i]->SetPos(x, y, z);
  }  
}

void 
Mesh::SetRotate(float x, float y, float z)
{
  Vertex::SetRotate(x, y, z);
  for (int i = 0; i < faces_.size(); i++) {
    faces_[i]->SetRotate(x, y, z);
  }  
}

void 
Mesh::SetScale(float x, float y, float z)
{
  Vertex::SetScale(x, y, z);
  for (int i = 0; i < faces_.size(); i++) {
    faces_[i]->SetScale(x, y, z);
  }  
}
#endif

float
Mesh::GetVolume(void)
{
  /* take advantage of the fact we only have 1 face, so this is technically the area */
  return (faces_[0]->GetArea() * MAX(s_.x, s_.y));
}

void 
Mesh::SelectMaterial(int i)
{
	if (i >= materials_.size()) {
		return;
	}
	GLfloat alpha = materials_[i].alpha;
	SetMaterial(GL_AMBIENT, materials_[i].ambient, alpha);
	SetMaterial(GL_DIFFUSE, materials_[i].diffuse, alpha);
	SetMaterial(GL_SPECULAR, materials_[i].specular, alpha);
	SetMaterial(GL_EMISSION, materials_[i].emission, alpha);
}

void
Mesh::SetName(const char *name) 
{
  if (objname_ != 0) {
    delete objname_;
  }
  objname_ = new char[strlen(name) + 1];
  strcpy(objname_, name);
}

void
Mesh::SetSelected(int pred)
{
  b_selected_ = pred;
}

const char*
Mesh::GetName(void)
{
  if (objname_ == 0) {
    return "undefined";
  }
  else {
    return objname_;
  }
}

void 
Mesh::SetMaterial(int mode, float *f, float alpha)
{
	GLfloat d[4];
	d[0]=f[0];
	d[1]=f[1];
	d[2]=f[2];
	d[3]=alpha;
	glMaterialfv(GL_FRONT_AND_BACK, mode, d);
}
