#if !defined(OBJECT3D_H)
#define OBJECT3D_H

#include "Physics.h"
#include "../struct.h"
#include <vector>

// Forward declarations
class Texture;

class Object3d : public Physics {
public:
	static void SetGlobalObjIDBase(int base);

	Object3d();
	Object3d(float x, float y, float z);
	Object3d& operator=(Object3d &o);
	virtual ~Object3d();

	virtual int PreDraw(void);
	virtual int Draw(void);
	virtual int Update(double timedelta);

	virtual int ResetTransformations(void);
	virtual int MakeUnitSize(void);

	virtual int BeginDef(void);
	virtual int EndDef(void);

	virtual void ChangeScale(float dx, float dy, float dz);

  virtual float Distance(Object3d &obj);

	virtual void SetName(const char *name);
	virtual void SetScale(float x, float y, float z);
	virtual void SetColor(float r, float g, float b);
	virtual void SetMaterial(MATERIAL &mat);
	virtual void SetSelected(bool pred);
	virtual void SetTexture(Texture *texobj);
	virtual void SetTexture(void);
	
	virtual void SetVertices(float *vertices, int size);
	virtual void SetNormals(float *normals, int size);
	virtual void SetIndices(unsigned int *indices, int size);
	virtual void SetTexVertices(float *vertices, int size);
	virtual void SetTexIndices(unsigned int *indices, int size);

	virtual const char* GetName(void);
	virtual int GetObjID(void);
	virtual bool GetSelected(void);
	virtual float* GetScale(void);
	virtual float* GetColor(void);
	virtual int GetBoundingBox(float *x1, float *x2, float *y1, float *y2, float *z1, float *z2);

	
	enum ERR_STATUS {
		ERR_FAIL = 0,
		ERR_OK = 1
	};

protected:
	void SetMaterial(int mode, float *f, float alpha);
	void SelectMaterial(int i);

	//
	// Member variables
	//
	int				objid_;				  // unique id of object
	char			objname_[64];		// name of object
	float			scale_[3];			// size of object
	float			color_[3];			// RGB color of object
	bool			bSelected_;			// is this item currently selected?
	Texture		*texobj_;			  // Texture object. NULL if none.
	bool			bHasTexture_;		// Override texobj_ indicator
  double    counter_;       // User-defined accumulator for timedelta

	float *vertices_; 
	int vertices_size_;

	float *normals_;
	int normals_size_;

  unsigned int *indices_;
	int indices_size_;

	float *tex_vertices_;
	int tex_vertices_size_;

	unsigned int *tex_indices_;
	int tex_indices_size_;

	std::vector<MATERIAL> materials_;	// Holds one or more material definitions

	enum COLOR_INDICES { RED = 0, GREEN = 1, BLUE = 2 };
  enum COORD_INDICES { X = 0, Y = 1, Z = 2 };

	static int GLOBAL_OBJ_ID;

	static float cube_vertices_[]; 
	static float cube_normals_[];
  static unsigned char cube_indices_[];
};

#endif /* OBJECT3D_H */