#include "Physics.h"
#include <stdio.h>

Physics::Physics() :
	mass_(1),
  counter_(0),
  period_(0)
{
  //fprintf(stderr, "Physics()\n");
}

Physics::Physics(const Physics &l) :
  p_(l.p_),
  r_(l.r_),
  dp_(l.dp_),
  dr_(l.dr_),
  velp_(l.velp_),
  velr_(l.velr_),
  accelp_(l.accelp_),
  accelr_(l.accelr_),
  restp_(l.restp_),
  restr_(l.restr_),
  destp_(l.destp_),
  mass_(l.mass_),
  counter_(l.counter_),
  period_(l.period_)
{
  //fprintf(stderr, "Physics(copy)\n");
}

Physics::Physics(float x, float y, float z, float mass) :
  p_(x, y, z),
  restp_(x, y, z),
  mass_(mass),
  counter_(0),
  period_(0)
{
  //fprintf(stderr, "Physics(...)\n");
}

Physics::~Physics()
{
}

void
Physics::Reset(void)
{
  p_ = restp_;
  r_ = restr_;
  dp_ = 0;
  dr_ = 0;
  velp_ = 0;
  velr_ = 0;
  accelp_ = 0;
  accelr_ = 0;
  counter_ = 0;
  period_ = 0;
  destp_ = restp_;
}

#define THRESHOLD 0.7f
void
Physics::Update(float timedelta)
{
#if 1
  float t = period_ * THRESHOLD;
  /* 0...0.9P */
  if (counter_ < t) {
    /* About to expire? */
    if (counter_ + timedelta >= t) {
      /* Let t = counter_ since we can't hit it exactly */
      accelp_ = (accelp_ * -counter_) / (period_ - counter_);
    }
  }
  /* 0.9P...P */
  else if (counter_ < period_) {
    /* About to expire for good? */
    if (counter_ + timedelta >= period_) {
      accelp_ = 0;
      velp_ = 0;
      p_ = destp_;
    }
  }
  else {
    //return;
  }
#endif

#if 0
	/* 
   * Friction 
	 * Note that friction depends on the velocity of the particle
	 * Faster = more friction, slower = less friction
	 */
	if (velp_.x > 0) {
		velp_.x -= FRICTION_AIR * timedelta * velp_.x;  
		if (velp_.x < 0) velp_.x = 0;
	}
	else {
		velp_.x -= FRICTION_AIR * timedelta * velp_.x;
		if (velp_.x > 0) velp_.x = 0;
	}

	if (velp_.y > 0) {
		velp_.y -= FRICTION_AIR * timedelta * velp_.y;
		if (velp_.y < 0) velp_.y = 0;
	}
	else {
		velp_.y -= FRICTION_AIR * timedelta * velp_.y;
		if (velp_.y > 0) velp_.y = 0;
	}

	if (velp_.z > 0) {
		velp_.z -= FRICTION_AIR * timedelta * velp_.z;
		if (velp_.z < 0) velp_.z = 0;
	}
	else {
		velp_.z -= FRICTION_AIR * timedelta * velp_.z;
		if (velp_.z > 0) velp_.z = 0;
	}
#endif

  /* 
   * Particle acceleration
   */
  velp_ = velp_ + accelp_ * timedelta;

  /* Reducing acceleration?  Seems kinda weird.  Leave it for now.  */
  //accelp_ = accelp_ - accelp_ * timedelta;

	/* Update position */
  dp_ = velp_ * timedelta;
  p_ = p_ + dp_;

  /* Update timer */
  counter_ += timedelta;
}

void
Physics::Goto(float time, float x, float y, float z)
{
  if (time == 0) {
    Reset();
    p_.Set(x, y, z);
  }
  else {
    counter_ = 0;
    period_ = time;
    destp_.Set(x, y, z);

    float t = time * THRESHOLD;
    vector3f d = destp_ - p_;
    accelp_ = d * 2 / (t * time);  /* see notes in Intel notebook */
  }
}

void
Physics::GotoRest(float time)
{
  Goto(time, restp_.x, restp_.y, restp_.z);
}