#ifndef PHYSICS_H
#define PHYSICS_H

const float FRICTION_AIR = 0.4f;

#include "vector3f.h"

class Physics {
public:
	Physics();
  Physics(const Physics &l);
	Physics(float x, float y, float z, float mass);
	virtual ~Physics();
  virtual void Reset(void);
  virtual void Update(float timedelta);
  virtual void Goto(float time, float x, float y, float z);
  virtual void GotoRest(float time);

  virtual void SetPos(float x, float y, float z) { p_.Set(x, y, z); }
  virtual void SetRotate(float x, float y, float z) { r_.Set(x, y, z); }

  vector3f p_;            /* Position */
  vector3f r_;            /* Rotation */
  vector3f dp_;           /* Delta position */
  vector3f dr_;           /* Delta rotation */
  vector3f velp_;         /* Velocity position */
  vector3f velr_;         /* Velocity rotation */
  vector3f accelp_;       /* Acceleration position */
  vector3f accelr_;       /* Acceleration rotation */
	float mass_;

  /* "Home" location */
  vector3f restp_;        /* Rest position */
  vector3f restr_;        /* Rest rotation */

  /* Timers */
  float counter_;
  float period_;

  /* Destination points */
  vector3f destp_;        /* Destination position */

};

#endif /* PHYSICS_H */