#include "Object3d.h"
#include "Plane.h"
#include "../Options.h"

Plane::Plane()
{
}

Plane::Plane(float x, float y, float z, float width, float height, float depth) :
  Object3d(x, y, z)
{
	SetScale(width / 2, height / 2, depth / 2);
}


Plane::~Plane()
{
}

int 
Plane::Draw(void)
{
	glPushMatrix();
	glTranslatef(p_.x, p_.y, p_.z);
	glScalef(scale_[X], scale_[Y], scale_[Z]);
	glColor3f(color_[RED], color_[GREEN], color_[BLUE]);	

	glBegin(GL_QUADS);
		glVertex3f(1.0f, 0, 1.0f);
		glVertex3f(-1.0f, 0, 1.0f);
		glVertex3f(-1.0f, 0, -1.0f);
		glVertex3f(1.0f, 0, -1.0f);
	glEnd();

	glPopMatrix();

	return ERR_OK;
}

int 
Plane::Update(double timedelta)
{

	return ERR_OK;
}
