#include "Texture.h"
#include "../Options.h"

int Texture::GLOBAL_TEX_ID = 1;

Texture::Texture(const char *name) :
	textureid_(-1)
{
	SetName(name);
	SetDimensions(0, 0);
	dimensions_[2] = 0;  // not currently implemented

	// Create texture object
	glGenTextures(1, &objid_);

	// Set this object as current
	Bind();

	//
	// Set up textures
	//
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
}

Texture::Texture(const char *name, int textureid) :
	textureid_(textureid)
{
	if (textureid >= GLOBAL_TEX_ID) {
		GLOBAL_TEX_ID = textureid + 1;
	}
	SetName(name);
	SetDimensions(0, 0);
	dimensions_[2] = 0;  // not currently implemented

	// Create texture object
	glGenTextures(1, &objid_);

	// Set this object as current
	Bind();

	//
	// Set up textures
	//
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
}

Texture::~Texture() 
{
	glGenTextures(1, &objid_);
}

int
Texture::Initialize(int width, int height)
{
	SetDimensions(width, height);

	return ERR_OK;
}

void
Texture::Bind(void)
{
	glBindTexture(GL_TEXTURE_2D, objid_);
}

void
Texture::SetName(const char *name)
{
	strncpy(objname_, name, 64);
	objname_[63] = 0;  // guarantee null-terminated
}

void 
Texture::SetDimensions(int width, int height)
{
	dimensions_[0] = width;
	dimensions_[1] = height;
}

void
Texture::SetTexID(int id)
{
	textureid_ = id;
	if (textureid_ >= GLOBAL_TEX_ID) {
		GLOBAL_TEX_ID = textureid_ + 1;
	}
}

const char*
Texture::GetName(void)
{
	return objname_;
}

int*
Texture::GetDimensions(void)
{
	return dimensions_;
}

int
Texture::GetObjID(void)
{
	return objid_;
}

int
Texture::GetTexID(void)
{
	if (textureid_ == -1) {
		textureid_ = GLOBAL_TEX_ID++;
	}
	return textureid_;
}
