#if !defined(TEXTURE_H)
#define TEXTURE_H

#include <vector>

class Texture {
public:

	Texture(const char *name);
	Texture(const char *name, int textureid);
	virtual ~Texture();

	virtual int Initialize(int width, int height);
	virtual void Bind(void);

	virtual void SetName(const char *name);
	virtual void SetDimensions(int width, int height);
	virtual void SetTexID(int id);

	virtual const char* GetName(void);
	int* GetDimensions(void);
	virtual int GetObjID(void);
	virtual int GetTexID(void);

	
	enum ERR_STATUS {
		ERR_FAIL = 0,
		ERR_OK = 1
	};

protected:

	//
	// Member variables
	//
	unsigned int	objid_;				// unique id for OpenGL
	int				textureid_;			// unique id for map
	char			objname_[64];		// name of object
	int				dimensions_[3];		// width, height, (depth) of texture

	static int GLOBAL_TEX_ID;

};

#endif /* TEXTURE_H */