#include "Triangle.h"
#include "Mesh.h"
#include "../Options.h"
#include <math.h>  // sin

Triangle::Triangle()
{
}

Triangle::Triangle(float x1, float y1, float z1, float width, float height) :
  Mesh(x1, y1, z1),
  counter_(0)
{
  SetScale(width / 2, height / 2, 1.0);
  swaytime_ = (rand() % 40) / 10.0 + 3;
  maxsway_ = (rand() % 50) / 20 + 2;
  
  Vertex *v1 = new Vertex(0.0, 0.9, 0);
  Vertex *v2 = new Vertex(-1.0, -0.85, 0);
  Vertex *v3 = new Vertex(1.0, -0.85, 0);
  Edge *e1 = new Edge(v1, v2);
  Edge *e2 = new Edge(v2, v3, e1);
  Edge *e3 = new Edge(v3, v1, e2);
  Face *face = new Face(e1, 3);
  faces_.push_back(face);
}

Triangle::~Triangle()
{
}

int 
Triangle::Draw(void)
{
	glPushMatrix();
  glDisable(GL_TEXTURE_2D);
	glTranslatef(p_.x, p_.y, p_.z);
	glScalef(s_.x, s_.x, s_.x);
	glRotatef(r_.x, 1.0f, 0.0, 0.0);
	glRotatef(r_.y, 0.0, 1.0f, 0.0);
	glRotatef(r_.z, 0.0, 0.0, 1.0f);
  if (b_selected_) {
    glColor3f(c_.x * HIGHLIGHT_SCALE, c_.y * HIGHLIGHT_SCALE, c_.z * HIGHLIGHT_SCALE);	  
  }
  else {
	  glColor3f(c_.x, c_.y, c_.z);	
  }
  faces_[0]->Draw();
  glPopMatrix();

#if 0
	glPushMatrix();
	glDisable(GL_TEXTURE_2D);  // stop using texture objects
	glTranslatef(p_.x, p_.y, p_.z);
	glScalef(s_.x, s_.x, s_.x);
	glRotatef(r_.x, 1.0f, 0.0, 0.0);
	glRotatef(r_.y, 0.0, 1.0f, 0.0);
	glRotatef(r_.z, 0.0, 0.0, 1.0f);
  if (b_selected_) {
    glLineWidth(3.0f);
   	glEnable(GL_POLYGON_OFFSET_FILL);
  	glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
  	glPolygonOffset(-1.0, -1.0);
  	glColor3f(1.0, 1.0, 1.0);
	  glBegin(GL_TRIANGLES);
      glVertex3f(0.0f, 0.90f, 0.0);
		  glVertex3f(-1.0f, -0.85f, 0.0);
		  glVertex3f(1.0f, -0.85f, 0.0);
	  glEnd();
    glLineWidth(2.0f);
    glDisable(GL_POLYGON_OFFSET_FILL);
  	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
    glColor3f(color_[RED] / 2, color_[GREEN] / 2, color_[BLUE] / 2);	  
  }
  else {
	  glColor3f(color_[RED], color_[GREEN], color_[BLUE]);	
  }
	glBegin(GL_TRIANGLES);
    glNormal3f(0.0, 0.0, 1.0f);
    glVertex3f(0.0f, 1.0f, 0.0);
    glNormal3f(0.0, 0.0, 1.0f);
		glVertex3f(-1.0f, -0.8f, 0.0);
    glNormal3f(0.0, 0.0, 1.0f);
		glVertex3f(1.0f, -0.8f, 0.0);
	glEnd();

	glPopMatrix();
#endif

	return ERR_OK;
}

void
Triangle::Update(float timedelta)
{
  Mesh::Update(timedelta);
#ifndef DYNAMISM
  counter_ += timedelta;
  if (counter_ > swaytime_) counter_ = 0;
  float ds = maxsway_ * sin(PI2 * counter_ / swaytime_);
  SetRotate(0, 0, ds);
  //ChangeScale(1 + ds, 1 + ds, 0);
#endif
}
