#include "vector3f.h"

vector3f::vector3f() :
  x(0),
  y(0),
  z(0)
{
}

vector3f::vector3f(float x1, float y1, float z1) :
  x(x1),
  y(y1),
  z(z1)
{
}

vector3f::vector3f(const vector3f &v) :
  x(v.x),
  y(v.y),
  z(v.z)
{
}

void
vector3f::Set(float x1, float y1, float z1)
{
  x = x1;
  y = y1;
  z = z1;
}

void
vector3f::Change(float dx, float dy, float dz)
{
  x += dx;
  y += dy;
  z += dz;
}

vector3f&
vector3f::operator = (vector3f &v)
{
  x = v.x;
  y = v.y;
  z = v.z;
  return (*this);
}

vector3f&
vector3f::operator = (float c)
{
  x = c;
  y = c;
  z = c;
  return (*this);
}

vector3f 
vector3f::operator + (vector3f &v)
{
  return vector3f(x + v.x, y + v.y, z + v.z);
}

vector3f 
vector3f::operator - (vector3f &v)
{
  return vector3f(x - v.x, y - v.y, z - v.z);
}

vector3f 
vector3f::operator * (vector3f &v)
{
  return vector3f(x * v.x, y * v.y, z * v.z);
}

vector3f 
vector3f::operator / (vector3f &v)
{
  return vector3f(x / v.x, y / v.y, z / v.z);
}

vector3f 
vector3f::operator + (float c)
{
  return vector3f(x + c, y + c, z + c);
}

vector3f 
vector3f::operator - (float c)
{
  return vector3f(x - c, y - c, z - c);
}

vector3f 
vector3f::operator * (float c)
{
  return vector3f(x * c, y * c, z * c);
}

vector3f 
vector3f::operator / (float c)
{
  return vector3f(x / c, y / c, z / c);
}

