// ==============================================
// Singleton to manage global variables and functions
// ==============================================
#if !defined(OPTIONS_H)
#define OPTIONS_H

#include <GL/glut.h>
#include <stdio.h>
#include <stdlib.h>
#include "struct.h"
#include <vector>
#include <list>

#define FAIL(i) ((i) != 1)

#define HIGHLIGHT_SCALE   1.4

// Forward declarations
class Object3d;
class Texture;
class UIMap;

// Typedefs
typedef std::vector<Texture*> Texture_Vector;
typedef std::list<Object3d*> Object3d_List;
typedef std::vector<Object3d*> Object3d_Vector;


class Options {
public:
	static Options *instance (void);		// singleton accessor
	~Options(void);

	double GetTimeDelta(void);
  double GetTime(void);

	int FindTexture(const char *name);

	//
	// State of menu items
	//
	int bLightingGlobal_;
	int bLightingLight01_;
	int bColorMaterial_;

	//
	// 3D Object stuff
	//
	Object3d_Vector models_;
	int num_models_;
	int curModel_;					// Used to track currently selected menu item
	
	Texture_Vector textures_;
	int num_textures_;
	int curTexture_;				// Used to track currently selected menu item

	//
	// OpenGL stuff
	//
	float global_ambient_[4];		/* World ambient light. */
	float light_ambient_[4];			/* Light ambient light. */
	float light_diffuse_[4];			/* White diffuse light. */
	float light_specular_[4];		/* Color of light. */
	float light_position_[4];		/* Directional light */

	// TODO - replace with a LIGHT_INFO struct


	enum ERR_STATUS {
		ERR_FAIL = 0,
		ERR_OK = 1,
	};

protected:
	// Singleton!
	Options(void);
    static Options *instance_;

private:
#ifdef WIN32
	__int64				timer_freq_;		// High resolution timer
	double				timer_freqINV_;		// Inverse (1 / timer_freq_)
  __int64       prev_time_;
#else
  int           prev_time_;
#endif

};


struct COORD_3D
{
	float x;
	float y;
	float z;
};

struct IMAGE_DATA {
	unsigned char r;
	unsigned char g;
	unsigned char b;
	unsigned char a;
};

void multMatrices(const GLfloat a[16], const GLfloat b[16], GLfloat r[16]);

void makeIdentity(GLfloat m[16]);

int invertMatrix(const GLfloat src[16], GLfloat inverse[16]);


#endif  /* OPTIONS_H */

