#if !defined(UIMAP_H)
#define UIMAP_H

#pragma warning (disable : 4786)  // truncate template name

#include <list>
#include <vector>
#include "3d/Texture.h"
#include "fileloader.h"

#define RESET_TIME 30.0

/* Forward declaration */
class Mesh;
class Object3d;

class UIMap {
public:
	UIMap();
	 ~UIMap();

	int Initialize(const char *szFilename);

  void BuildShapes(void);

  void BuildUI(void);

  void SetUI(int type);

	void SetProjection(int x, int y, int width, int height);

	int Draw(int mode);

	void Update(float timedelta);

  void MouseDown(int x, int y, int btn);
  void MouseUp(int x, int y, int btn);
  void MouseMove(int x, int y);

	//int HandleMouse(int x, int y, int btn, int state);

	int HandleKey(unsigned char key, int state);

	void SetMouseScale(void);
	
	void DeselectAll(void);

	void ApplyTextureToSelection(Texture *texobj);

  void DoConnection(Mesh *s1, Mesh *s2);

  void SetAverageColor(int left, int top, int right, int bottom, Mesh *obj);

  Mesh* CreateShape(int type, int x, int y);

  /*
   * Effects
   */

  void ShootUp(void);
  void ShootDown(void);


	enum ERR_STATUS {
		ERR_FAIL = 0,
		ERR_OK = 1,
		ERR_NEEDREDRAW = 2
	};

protected:
	int PickObject(int x, int y);

	int SelectObjects(int x1, int y1, int x2, int y2);

	int ProcessHits(int hits, unsigned int buffer[]);

	int ComputeCoords(int mousex, int mousey, float * selx, float * sely);

	

private:
	//std::vector<Object_List&> obj_by_tex_;
  std::vector<Mesh*> obj_vec_;
	std::vector<int> obj_selected_;
  Mesh* obj_undercurs_;

  /* Ground plane */
	Object3d *groundplane_;
  unsigned char *img_;
  int img_width_;
  int img_height_;

  /* UI Elements, Buttons */
  std::vector<Mesh*> buttons_;
  std::vector<int> buttons_selected_;

  REGION_MAP rgnmap_;

  int width_;
  int height_;
	float camera_x_;
	float camera_y_;
	float camera_z_;

	float near_;
	float far_;
	float fov_;

	int mouse_x_;
	int mouse_y_;
  int mouse_x_down_;
  int mouse_y_down_;
	float mouse_scalex_;  // screen to world
	float mouse_scaley_;  // screen to world

	// Rectangular selection marquee
  enum MARQUEE_TYPE {
    MARQ_NONE,
    MARQ_LINE,
    MARQ_CIRC,
    MARQ_TRI1,
    MARQ_TRI2
  };
  int marq_type_;
	float marq_x_;
	float marq_y_;
  float marq_time_;
  float marq_x2_;
  float marq_y2_;
  float marq_time2_;
	
  // Special effects
  enum EFFECTS {
    EFFECT_NONE,
    EFFECT_SHOOTUP,
    EFFECT_SHOOTDOWN
  };
  int effect_type_;
  double period_;
  double counter_;
  double inactivity_;

  // State of cursor / program
  enum STATE {
    STATE_NONE,
    STATE_MANIPULATE,
    STATE_PLACE,
    STATE_THROW,
    STATE_MARQ,
    STATE_EFFECT
  };

  enum SHAPES {
    PARALLELOGRAM = 0,
    CIRCLE = 1,
    SQUARE = 2,
    TRIANGLE = 3
  };
  
  int leftstate_;
  int rightstate_;
  int curshape_;

};


#endif  /* UIMAP_H */