#include "fileloader.h"
#include "utils.h"

#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif

int 
load_map(char *filename, REGION_MAP &map)
{
  FILE *f = fopen(filename, "r");
  if (f == NULL) {
    abort("error opening map file\n");
    return 0;
  }
  if (fscanf(f, "regions %d\nbackground %d\n", &map.regions, &map.background) < 2) {
    abort("error loading header from map file\n");
  }
  
  REGION_INFO ri;
  int region, grey, r, g, b;
  for (int i = 0; i < map.regions; i++) {
    if (fscanf(f, "%d %x %d %d %d\n", &region, &grey, &r, &g, &b) < 5) {
      abort("error loading region data from map file\n");
    }
    ri.region = region;
    ri.r = r;
    ri.g = g;
    ri.b = b;
    map.map[grey] = ri;
  }
  fclose(f);
  return 1;
}

unsigned char*
load_ppm(char *filename, int *width, int *height, int *bitdepth)
{
  char str_type[3];
  int maxval;
  unsigned char *pix;
  int pix_size;
  FILE *f = fopen(filename, "r");
  if (f == NULL) {
    abort("error opening ppm file\n");
    return 0;
  }
  fscanf(f, "%s\n", str_type);
  if (strcmp(str_type, "P6") != 0) {
    abort("ppm type not P6\n");
    return 0;
  }
  fscanf(f, "%d %d\n", width, height);
  fscanf(f, "%d\n", &maxval);
  pix_size = (*width) * (*height) * 3;
  pix = new unsigned char[pix_size];
  for (int y = *height - 1; y >= 0; y--) {
    for (int x = 0; x < *width * 3; x++) {
      pix[y * (*width) * 3 + x] = getc(f);
    }
  }
  //for (int i = 0; i < pix_size; i++) {
  //  pix[i] = getc(f);
  //}
  *bitdepth = 24;
  fclose(f);
  return pix;
}

unsigned char*
load_ppm32(char *filename, int *width, int *height, int *bitdepth)
{
  char str_type[3];
  int maxval;
  unsigned char *pix;
  int pix_size;
  FILE *f = fopen(filename, "rb");
  if (f == NULL) {
    abort("error opening ppm file\n");
    return 0;
  }
  fscanf(f, "%s\n", str_type);
  if (strcmp(str_type, "P6") != 0) {
    abort("ppm type not P6\n");
    return 0;
  }
  fscanf(f, "%d %d\n", width, height);
  fscanf(f, "%d\n", &maxval);
  pix = new unsigned char[(*width) * (*height) * 4];
  pix_size = (*width) * (*height);
  for (int y = *height - 1; y >= 0; y--) {
    for (int x = 0; x < *width; x++) {
      pix[(y * (*width) + x) * 4 + 0] = getc(f);
      pix[(y * (*width) + x) * 4 + 1] = getc(f);
      pix[(y * (*width) + x) * 4 + 2] = getc(f);
      pix[(y * (*width) + x) * 4 + 3] = 255;
    }
  }
  //for (int i = 0; i < pix_size; i++) {
  //  pix[(i << 2) + 0] = getc(f);
  //  pix[(i << 2) + 1] = getc(f);
  //  pix[(i << 2) + 2] = getc(f);
  //  pix[(i << 2) + 3] = 255;
  //}
  *bitdepth = 32;
  fclose(f);
  return pix;
}

unsigned char*
load_pgm(char *filename, int *width, int *height)
{
  char str_type[3];
  int maxval;
  unsigned char *pix;
  int pix_size;
  FILE *f = fopen(filename, "r");
  if (f == NULL) {
    abort("error opening pgm file\n");
    return 0;
  }
  fscanf(f, "%s\n", str_type);
  if (strcmp(str_type, "P5") != 0) {
    abort("pgm type not P5\n");
    return 0;
  }
  fscanf(f, "%d %d\n", width, height);
  fscanf(f, "%d\n", &maxval);
  pix_size = (*width) * (*height);
  pix = new unsigned char[pix_size];
  for (int y = *height - 1; y >= 0; y--) {
    for (int x = 0; x < *width; x++) {
      pix[y * (*width) + x] = getc(f);
    }
  }
  //for (int i = 0; i < pix_size; i++) {
  //  pix[i] = getc(f);
  //}
  fclose(f);
  return pix;
}

#ifdef WIN32
//-----------------------------------------------------------------------------
// Desc: Creates an RGBA array of data.
//       This is Windows-dependent!
// From: Modified code used in Bytor (http://biggreenball.dhs.org/bytor/)
//-----------------------------------------------------------------------------
unsigned char*
load_bmp(const char* szBitmap, int *imagewidth, int *imageheight)
{
	HDC						hdc;
	HBITMAP 				hbm;
	BITMAP					bm;

	//	Try to load the bitmap as a resource, if that fails, try it as a file
	//
	hbm = (HBITMAP) LoadImage(GetModuleHandle(NULL), szBitmap, IMAGE_BITMAP, 0, 0, LR_CREATEDIBSECTION);
	if (hbm == NULL)
		hbm = (HBITMAP) LoadImage(NULL, szBitmap, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE | LR_CREATEDIBSECTION);
	if (hbm == NULL) {
		printf("LoadBitmap failed at LoadImage.\n");
		return 0;
	}
	//
	// Get and set size of the bitmap
	//
	GetObject(hbm, sizeof(bm), &bm);
	*imagewidth = bm.bmWidth;
	*imageheight = bm.bmHeight;

	//
	// Get data
	//

    hdc = CreateCompatibleDC(NULL);
    if (!hdc) {
		DeleteObject(hbm);
		printf("LoadBitmap failed CreateComaptibleDC.\n");
		return 0;
	}
    SelectObject(hdc, hbm);

	// Slow slow slow ...... can't we just copy the buffer AND flip
	// the top/bottom right/left data AND add an 
	// alpha bit at the same time ??
	COLORREF c;
	int lineptr;
	unsigned char *data = new unsigned char[bm.bmWidth * bm.bmHeight * 4];
	for (int y = 0; y < bm.bmHeight; y++) {
		lineptr = y * bm.bmWidth * 4;
		for (int x = 0; x < bm.bmWidth; x++) {
			// BMP files are in reverse order (right to left)
			c = GetPixel(hdc, x, (bm.bmHeight - y - 1));
			//c = GetPixel(hdc, (bm.bmWidth - x - 1), y);
			//c = GetPixel(hdc, x, y);  // leave this in.  world is fun.  wheeeee!!
			if (c != CLR_INVALID) {
				data[lineptr + (x << 2) + 0] = c & 0x000000FF;         // red
				data[lineptr + (x << 2) + 1] = (c & 0x0000FF00) >> 8;  // green
				data[lineptr + (x << 2) + 2] = (c & 0x00FF0000) >> 16; // blue
				data[lineptr + (x << 2) + 3] = (char)255;              // alpha
			}
		}
	}	
	
	//
	// Clean up memory
	//
	DeleteDC(hdc);
	DeleteObject(hbm);

	return data;
}
#endif
