#ifndef FILELOADER_H
#define FILELOADER_H

#pragma warning (disable : 4786)  // truncate template name

#include <stdio.h>
#include <map>

struct REGION_INFO
{
  unsigned char region;
  unsigned char r;
  unsigned char g;
  unsigned char b;
};

struct REGION_MAP
{
  int regions;
  int background;
  std::map<int, REGION_INFO> map;

  unsigned char *mask;
  int width;
  int height;
};

int load_map(char *filename, REGION_MAP &map);

unsigned char* load_ppm(char *filename, int* width, int* height, int* bitdepth);

unsigned char* load_ppm32(char *filename, int* width, int* height, int* bitdepth);

unsigned char* load_pgm(char *filename, int* width, int* height);

#ifdef WIN32
unsigned char* load_bmp(const char* szBitmap, int *imagewidth, int *imageheight);
#endif

#endif  /* FILELOADER_H */
