#include "globals.h"
#include "FileLoader.h"
//#include <iostream.h>
#include <math.h>
#include <list>

#pragma warning (disable : 4101)

#define FULLSCREEN

/* global variables */
bool b_paused_ = false;
int viewportw_;
int viewporth_;
UIMap map_;
int orig_window_ = 0;
int cur_window_;

/*
 * THE FUNCTIONS
 */

void DisplayFunc(void)
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	map_.SetProjection(0, 0, viewportw_, viewporth_);
	map_.Draw(GL_RENDER);

	glFlush();
	glutSwapBuffers(); 
}

void PostRedisplay(void)
{
  glutPostWindowRedisplay(cur_window_);
	//glutPostRedisplay();
}

void KeyboardFunc(unsigned char key, int x, int y)
{
	int r1 = map_.HandleKey(key, 0);
	if (r1 == UIMap::ERR_NEEDREDRAW) {
		PostRedisplay();
	}
  switch (key) {
  case '`':  /* ESC */
#ifdef FULLSCREEN
    glutLeaveGameMode();
#endif
    exit(1);
  }
}

void MouseFunc(int btn, int state, int x, int y)
{
  if (state == GLUT_DOWN) 
    map_.MouseDown(x, y, btn);
  else if (state == GLUT_UP) 
    map_.MouseUp(x, y, btn);
  PostRedisplay();
}

void MotionFunc(int x, int y)
{
  map_.MouseMove(x, y);
  PostRedisplay();
}

void PassiveFunc(int x, int y)
{
  map_.MouseMove(x, y);
  PostRedisplay();
}

void IdleFunc()
{
  int result;
  double timedelta = Options::instance()->GetTimeDelta();
  map_.Update(timedelta);
  PostRedisplay();
}

void ReshapeFunc(int w, int h)
{
	viewportw_ = w;
	viewporth_ = h;
	
	map_.SetProjection(0, 0, viewportw_, viewporth_);
	map_.SetMouseScale();
}

void VisibleFunc(int vis)
{
  if (vis == GLUT_VISIBLE) {
    if (!b_paused_)
      glutIdleFunc(IdleFunc);
  }
  else {
    glutIdleFunc(NULL);
  }
}

void InitOpenGL(void)
{
	Options &o = *(Options::instance());

  glEnable(GL_NORMALIZE);  // poor performance...
	glEnable(GL_DEPTH_TEST); /* Enable hidden--surface--removal */
 	glEnable(GL_COLOR_MATERIAL);
  glShadeModel(GL_SMOOTH);

#ifdef ANTIALIAS
  glEnable(GL_LINE_SMOOTH);
  glEnable(GL_BLEND);
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  glHint(GL_LINE_SMOOTH_HINT, GL_DONT_CARE);
#endif
	glLineWidth(2.0);

  /* Lighting & coloring do not affect surface */
  glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);

#if 1
	/* Enable a single OpenGL light. */
	glLightfv(GL_LIGHT0, GL_AMBIENT, o.light_ambient_);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, o.light_diffuse_);
	glLightfv(GL_LIGHT0, GL_SPECULAR, o.light_specular_);
	glLightfv(GL_LIGHT0, GL_POSITION, o.light_position_);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
#endif

	/* Enable global ambient light */
	glLightModelfv(GL_LIGHT_MODEL_AMBIENT, o.global_ambient_);

}


int
main(int argc, char *argv[])
{
	Options &o = *(Options::instance());

  // Initialize GLUT, window stuff
  glutInit(&argc, argv);
  glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
#ifdef FULLSCREEN
  glutGameModeString("640x480:16@60");
  glutEnterGameMode();
#else
  glutInitWindowSize(640, 480);
  orig_window_ = glutCreateWindow("Art!");
#endif
	glutMouseFunc(MouseFunc);
	glutMotionFunc(MotionFunc);
	glutReshapeFunc(ReshapeFunc);
  glutDisplayFunc(DisplayFunc);
  glutIdleFunc(IdleFunc);
	glutKeyboardFunc(KeyboardFunc);
  glutPassiveMotionFunc(PassiveFunc);
  cur_window_ = glutGetWindow();

  // Initialize OpenGL stuff for my program
	InitOpenGL();

  //
	// Initialize UI
	//
  map_.Initialize("fruit");
  //map_.Initialize("fruit");
  
  o.GetTimeDelta();  // clear it out

  //
	// Program main loop
	//
  glutMainLoop();

  return 0;
}

