// struct.h

//******************************************
// copyright 1998	Mickey Kawick
// This file may be used anywhere for free, but this
// comment info must be left here.

// If you use this code in any shape or form or even
// as a reference for profit send me a dollar. 
// Not a dollar per copy, just a single US dollar. 

// If you are not in the US, send me
// a few different coins or the equivalent of a dollar.
// I love foreign currency, and I have a little collection.
// MKawick@sprintmail.com
//******************************************

//---------------------------------------------------------------------------

#if _MSC_VER
#pragma once		// include only once per build
//#pragma pack(2)		// pack all structures to 2 bytes
#endif


#ifndef __STRUCT_H_
#define __STRUCT_H_

#ifndef NULL
#define NULL 0L
#define DEFINENULL
#endif

#ifndef  __M_macro
#define  __M_macro
    
//---------------------------------------------------------------------------

#define  PI					3.14159265358979  // 180 degrees
#define  PI_LONG			3.141592653589793238462643383279502884197169399375105820974944
#define  PI2				6.283185307178    // 360 degrees
#define  PI2_LONG			6.283185307179586476925286766559005768394338798750211641949888
#define  PIx2				PI2               // 360 degrees
#define  PItimes2			PI2               // 360 degrees
#define  PIdiv2				1.570796326795    // 90 degrees
#define  PIover2			PIdiv2            // 90 degrees
#define  DEG90				PIdiv2            // same
#define  DEG270				-PIdiv2           // same
#define  DEG45				0.7853981633974   // 45 degrees
#define  DEG5				0.087266462599    // 5 degrees
#define  DEG10				0.174532925199    // 10 degrees
#define  DEG20				0.349065850398    // 20 degrees 
#define  DEG30				0.523598775597    // 30 degrees
#define  DEG60				1.047197551194    // 60 degrees
#define  DEG120				2.094395102388    // 120 degrees

#define  DEG40				0.698131700796    // 40 degrees
#define  DEG80				1.396263401592    // 80 degrees
#define  DEG160				2.792526803191    // 160 degrees
#define  DEG140				2.443460952792    // 140 degrees
#define  SQRT2				1.4142135623731   // 45* hypoteneuse
#define  SQRT_2				0.7071067811865	 // 1/SQRT2
#define  SQRT3				1.73205080757     // 30,60,90 60 degree side
#define  logNE				2.71828182845904523536	// natural log
#define  logN2				0.69314718055994530942   // doubling rate
#define  logN10				2.30258509299404568402	// 10x rate



////////////********************************************


template <typename type>					// RADtoDEG
type  RADtoDEG (type val) {return val * 57.2957795132;}
template <typename type>					// DEGtoRAD
type  DEGtoRAD (type val) {return val * 0.0174532925199;}
			
	//****************

template <typename type>					// ODD integers only
type  ODD (type a) {return (a&1);}
template <typename type>					// EVEN integers only
type  EVEN (type a) {return (!ODD(a));}
template <typename type>					// SGN
type  SGN (type a) {return ((a<0) ? -1:(a>0) ? 1:0);}
template <typename type>					// SQR
type  SQR (type a) {return a*a;}      
template <typename type>					// CUBE
type  CUBE (type a) {return a*a*a;}
template <typename type>					// ABS
type  ABS (type a) {return (a<0) ? -a:a;}
template <typename type>					// ROUND
type  ROUND (type a) {return (a>0 ? (type)((int)(a+0.5F)):-(type)((int)(0.5F-a)));}
template <typename type>					// TRUNC
type  TRUNC (type a) {return (int)(a);}

	//****************

template <typename type>					// MIN
type  MIN (type a, type b) {return ((a<b) ? a:b);}   
template <typename type>					// MIN smallest in array
type  MIN (type* array, int num) 
{
	type val = array[0];
	for (int i=1; i<num; i++)
	if (val>array[i]) val = array[i];
	return val;
} 
template <typename type>					// MIN3
type  MIN3 (type a, type b, type c) {return (MIN(MIN(a,b),c));}  
  
      
template <typename type>					// MAX
type  MAX (type a, type b) {return ((a>b) ? a:b);}    
template <typename type>					// MAX largest in array
type  MAX (type* array, int num) 
{
	type val = array[0];
	for (int i=1; i<num; i++)
	if (val<array[i]) val = array[i];
	return val;
} 
template <typename type>					// MAX3
type  MAX3 (type a, type b, type c) {return (MAX(MAX(a,b),c));}  


template <typename type>					// AVG
type  AVG (type a, type b) {return ((a+b)/2);} 
template <typename type>					// AVG of an array
type  AVG (type* array, int num) 
{
	type sum = array[0];
	for (int i=1; i<num; i++)
	sum += array[i];
	return sum/num;
} 

template <typename type>					// SUM add two numbers
type  SUM (type a) {return ((a)+(b));} 
template <typename type>					// SUM add array of numbers
type  SUM (type* array, int num) 
{
	type sum = array[0];
	for (int i=1; i<num; i++)
	sum += array[i];
	return sum;
} 

template <typename type>					// MEDIAN find the middle value in a list
type  MEDIAN (type* array, int num) 
{
	int Odd = (ODD(num));
	for (int i=0; i<num; i++)
	{
		int CountBelow = 0;
		int CountAbove = 0;
		for (int j=0; j<num; j++)
		{
			if (j == i) continue;
			if (array[i] <= array[j]) CountAbove ++;
			if (array[i] >= array[j]) CountBelow ++;
		}
		if (Odd)
		{
			if (CountBelow == CountAbove) return array[i];
		}
		else
		{
			if (CountBelow+1 >= CountAbove &&
				CountBelow-1 <= CountAbove) return array[i];
		}
	}
	return array[0];// should never happen, but just in case
}   

	//****************   
          
template <typename type>					// SWAP // a xor b; b xor a; a xor b;
void  SWAP (type& a, type& b) 
{
	//a^=b; b^=a; a^=b;
	type temp = a; a = b; b = temp;
  /*	_asm
	{
		mov         eax, [a]
		mov         edx, [b]
		mov         ebx, [eax]
		mov         ecx, [edx]
		mov         [edx], ebx	// pipeline stall
		mov         [eax], ecx		
	}     */
} 
#define  SWAPPT(a,b) (SWAP(a.y,b.y), SWAP(a.x,b.x))// SWAP swap points   
template <typename type>					// RECIP // a^-1
type  RECIP (type a) {return (1/a);}  
template <typename type>					// NOT  // exclusive or unary
type  NOT (type a) {return (~(a));} 
template <typename type>					// XOR exclusive or binary
type  XOR (type a, type b) {return (a^b);}  
template <typename type>					// BSL bit shift left
type  BSL (type a) {return (a<<1);} 
template <typename type>					// BSL2 bit shift left by b positions
type  BSL2 (type a, type b) {return (a<<b);}  
template <typename type>					// BSR  bit shift right
type  BSR (type a) {return (a>>1);} 
template <typename type>					// BSR2 bit shift right by b positions
type  BSR2 (type a, type b) {return (a>>b);}  
template <typename type>					// BIT turns a bit on
type  BIT (int x) {return (type)(1<<x);}  

	//****************

template <typename type>					// LO_BYTE
type  LO_BYTE (type a) {return (a&=0xff);}  
template <typename type>					// HI_BYTE 
type  HI_BYTE (type a) {return (a&=0xff00);} 
template <typename type>					// LO_WORD
type  LO_WORD (type a) {return (a&=0xffff);}  
template <typename type>					// HI_WORD 
type  HI_WORD (type a) {return (a&=0xffff0000);} 
template <typename type>					// HI_LOSWAPshort
type  HI_LOSWAPshort (type a) {return (LO_BYTE(a)<<8) | (HI_BYTE(a)>>8);}  
template <typename type>					// HI_LOSWAPlong
type  HI_LOSWAPlong (type x) {return (LO_WORD(a)<<16) | (HIWORD(a)>>16);}  

	//****************

template <typename type, typename type2>		// LIMIT limit the range of a number
type  LIMIT (type val, type2 l, type2 h) 
{
	if (val<l) return (type) l;
	if (val>h) return (type) h;
	return val;
} 

template <typename type, typename type2>		// WRAP_IT limits the range of a number
type  WRAP_IT (type val, type2 low, type2 high) // and wraps it around on top
{	
	type2 range = high - low;
	type2 t = static_cast <type2> ((int)(val/range));
	if (val>high) 
	{
		type2 t = static_cast <type2> ((int)(val/range));
		val -= static_cast <type> (range * t); //+/- range
		if (val>high)
		val = static_cast <type> (low) + val - static_cast <type>(high);
		return val;
	}
	if (val<low)
	{
		type2 t = static_cast <type2> ((int)(val/range));
		val -= static_cast <type> (range * t);
		if (val<low)
		val = static_cast <type> (high) + val-(type)low;
		return val;
	}
	return val;
} 

template <typename type>					// TORAD return the radian measure of the degrees passed
type  TORAD (type a) {return DEGtoRAD(a);}  
template <typename type>					// TODEG convert to degrees from radians
type  TODEG (type a) {return RADtoDEG(a);} 
template <typename type>					// CSC
type  CSC (type a) {return ((a==0 || a==DEG180) ? (type)0.0:(type)(1/sin(a)));}  
template <typename type>					// SEC
type  SEC (type a) {return ((a==DEG90 || a==DEG270) ? (type)1.0e18:(type)(1/cos(a)));} 
template <typename type>					// COT
type  COT (type a) {return ((a==DEG90 || a==DEG270) ? (type)1.0e18:(type)(1/tan(a)));}         
template <typename type>					// ARCSIN
type  ARCSIN (type a) {return (atan((a)/sqrt(-(a)*(a)+1)));}  
template <typename type>					// ARCCOS
type  ARCCOS (type a) {return (-atan((a)/sqrt(-(a)*(a)+1))+PIdiv2);} 


	//****************

template <typename type>					// perppos
type  perppos (type a) {return (a+PIdiv2);}         
template <typename type>					// perpneg
type  perpneg (type a) {return (a-PIdiv2);}  
template <typename type>					// DIST // convert to polar distance
type  DIST (type a, type b) {return (type)(sqrt(((a)*(a))+((b)*(b))));}         
template <typename type>					// ANGLE //pass either the xdist or ydist and return angle
type  ANGLE (type x, type y) {return ((x!=0) ? (type)cos(x) : (type)sin(y));}  

	//****************  the rest are better left as macros

#define  TOCELSIUS(a)        (((a)-32)/5*9)
#define  TOFAREN(a)          (((a)*5/9)+32)
#define  TOCENT(a)           ((a)*2.54)
#define  TOINCH(a)           ((a)*.3937)
#define  derive(a, x, b, c)  (((a)*(b))*pow((x),(b)-1))      // take the derivitive, in the form ax^b+c
#define  VOLCYLINDER(r,h)    ((h)*(PI*((r)*(r))))// cylinder volume
#define  VOLCUBE(s)          ((s)*(s)*(s))// cube
#define  VOLSPHERE(r)        (PI*((r)*(r)*(r)))// sphere volume
#define  SURCYLINDER(r,h)    ((h)*2*(r)*PI)// surface area
#define  SURCUBE(s)          ((x)*(x)*6)
#define  SURSPHERE(s)        (3*PI*(r)*(r))
#define  SURCONE(r,h)        (((PI*(r))*sqrt((r)*(r)+(h)*(h)))
#define  AREARECT(x,y)       ((x)*(y))
#define  AREACONE(r,h)       (((PI*(r)*(r))*h/3)
#define  AREACIRCLE(r)       ((PI*(r)*(r))
#define  AREATRIANGLE(b,h)   ((b)*(h)*0.5)
#define  GALTOLITRE(a)       ((a)*3.78541)
#define  LITRETOGAL(a)       ((a)*.264172)
#define  LB_toKG(a)          ((a)*.453592)
#define  KG_toLB(a)          ((a)*2.20462)
#define  GRAVITY(m1,m2,dist) ((((m1)+(m2))*0.0000000000667)/(dist*dist))   // attraction of two masses
#define  ACCELERATION(f,m)   ((f)/(m))
#define  VELOCITY(acc,time)  ((acc)/(time))
#define  WORK(m,v)           ((m)*(v)*(v))
#define  NEWTON(kg,meter)    ((kg)*(meter))
#define  GOLDEN_MEAN(a)		 ((a)*(0.61803398874990))

#endif


// this library is intended for 16bit graphics. All bitmaps will be converted from 4, 8,
// or 24 bit to a 16bit compressed format called lle. Ultimately, tiffs and
// some other formats will be supported.

#ifndef __STANDARD_TYPEDEFS__
#define __STANDARD_TYPEDEFS__

typedef unsigned char  Uint8,  U8,  * U8ptr;
typedef unsigned short Uint16, U16, * U16ptr;
typedef unsigned int   Uint32, U32, * U32ptr;
typedef unsigned long  Ulong,  UL,  * ULptr;

typedef          char  Sint8,  S8,  * S8ptr;
typedef          short Sint16, S16, * S16ptr;
typedef          int   Sint32, S32, * S32ptr;
typedef          long  Slong,  SL,  * SLptr;

typedef			 float FL, F32, *Fptr;
typedef			 double DB, D80, *Dptr;

typedef			 void* VoidPtr;

// special arrays for handling large numbers of bits

typedef unsigned int  BIT64[2], BIT128[4];

#endif

			//*********************************
			//*********************************

typedef
struct Point2f
{
  float x;
  float y;
  Point2f() { x = y = 0; }
  Point2f(float _x, float _y) { x = _x; y = _y; }
} Point2f;

			//*********************************
			//*********************************

typedef
struct Rectangle2f
{
  float left;
  float top;
  float right;
  float bottom;
  Rectangle2f() { left = top = right = bottom = 0; }
  Rectangle2f(float l, float t, float r, float b) { left = l; top = t; right = r; bottom = b; }
} Rectangle2f;

			//*********************************
			//*********************************

typedef
struct MATERIAL {
 float ambient[3];
 float diffuse[3];
 float specular[3];
 float emission[3];
 float alpha;
}MATERIAL;

typedef
struct DRAWSURFACE
{
	unsigned char *dest;
	int width;
	int height;
  	int size;
	U8 depth;  /* in bytes 8 */
  	int stride;
	DRAWSURFACE() {dest = 0, width = 0, height = 0, size = 0, depth = 0, stride = 0;}
}DRAWSURFACE, *DRAWSURFACEptr, **DRAWSURFACElist;

			//*********************************
			//*********************************

typedef 
struct RECTA
{
    int l, t, r, b;
	RECTA () {l = 0, t = 0, r = 0, b = 0;}
}RECTA, *RECTAptr, **RECTAlist;

			//*********************************
			//*********************************

typedef 
struct RECTANGLE
{
    U16		left, top, right, bottom;
	RECTANGLE () {left = 0, top = 0, right = 0, bottom = 0;}
	RECTANGLE (U16 l, U16 t, U16 r, U16 b) {left = l, top = t, right = r, bottom = b;}
	RECTANGLE (RECTANGLE& r) {left = r.left, top = r.top, right = r.right, bottom = r.bottom;}
	RECTANGLE& operator = (RECTANGLE& r) 
	{
		left = r.left, top = r.top, right = r.right, bottom = r.bottom;
		return *this;
	}
	void	Set (U16 l, U16 t, U16 r, U16 b) {left = l, top = t, right = r, bottom = b;}
}RECTANGLE, *RECTANGLEptr, **RECTANGLElist;

			//*********************************
			//*********************************
			//*********************************

typedef struct RGBVal
{
    enum  COLOR { RED, FUCHSIA, BLUE, CYAN, GREEN, YELLOW, WHITE, GRAY, BLACK };
	enum  {LOW = 0L, HIGH = 255};
	U8  b, g, r;
	//*******************
	RGBVal () {r = g = b = 0;}
	RGBVal (U8 er, U8 eg, U8 eb) {r=er, g=eg, b=eb;}
	RGBVal (const RGBVal& pal) {r=pal.r, g=pal.g, b=pal.b;}// copy constructor
	RGBVal (RGBVal* pal) {r=pal->r, g=pal->g, b=pal->b;}

	void SetVal (U8 er, U8 eg, U8 eb){r = er, g = eg, b = eb;}


	//*************************
	RGBVal operator = (long val) // in the form of 0x00ffffff
	{
		r = (U8)(val>>16);
		g = (U8)(val>>8);
		b = (U8)(val&0xff);
      return RGBVal (this);
	}

	void	SwapColor () {SWAP (b,r);}// green stays the same
	//******************* conversion to a from 16Bit
	U16 Convert15() { return (U16) (((r&248)<<7) + ((g&248)<<2) + (b>>3)); }
	U16 Convert16() { return (U16) (((r&248)<<8) + ((g&252)<<2) + (b>>3)); }
	RGBVal From15Bit (U16 bit)// pattern 11111 11111 11111 for red, green, and blue respectively
	{
		b=(U8)(((bit)<<3)&248);// low portion of 16bit value
		if (b) b|=7;// fill in the low 3 bits in case this color has a value
		// this is an effort to correct the problem of lost color when converting to
		// 16bit in the first place. Here we make white really white instead of an
		// off grey
		g=(U8)((bit>>2)&248);	if (g) g|=7;
		r=(U8)((bit>>7)&248); if (r) r|=7;
		return RGBVal (this);
	}
	RGBVal From16Bit (U16 bit)// pattern 11111 111111 11111 for red, green, and blue respectively
		// notice the extra bit in the green section
	{
		b=(U8)((bit<<3)&248);	if (b) b|=7;
		g=(U8)((bit>>2)&252);	if (g) g|=3;// we are working with 6 bits so we only need
									// the bottom 2
		r=(U8)((bit>>8)&248); if (r) r|=7;// red is one bit higher on the 16bit group
		return RGBVal (this);
	}
	//******************* assignment 
/*	RGBVal operator = (long val)// in the form of 0xffffff
	{
		r=(U8)(val>>16), g=(U8)(val>>8), b=(U8)(val);
		return RGBVal (this);
	}*/
	RGBVal operator = (RGBVal& pal)
	{
		r=pal.r, g=pal.g, b=pal.b;
		return RGBVal (this);
	}
	//******************* equal test
	bool operator == (long val)// in the form of 0xffffff
	{
		if (r==(U8)(val>>16) && g==(U8)(val>>8) && b==(U8)(val)) return true;
		return false;
	}
	bool operator == (RGBVal& pal)
	{
		if (r==pal.r && g==pal.g && b==pal.b) return true;
		return false;
	}
	bool operator > (RGBVal& pal)// absed on an average value
	{
		long dist = (r-pal.r) + (g-pal.g) + (b-pal.b);
		if (dist>0) return true;
		return false;
	}
	bool operator < (RGBVal& pal)
	{
		long dist = (r-pal.r) + (g-pal.g) + (b-pal.b);
		if (dist<0) return true;
		return false;
	}
	//******************* addition
	RGBVal operator += (RGBVal& pal)
	{
		long er = pal.r, ir = r;// store in a long for addition below. remember that a 
		//U8 wraps around at 255 so
		// any addition involving large numbers ruins your day
		long eg = pal.g, ig = g;
		long eb = pal.b, ib = b;
		// limit is a macro defined above
		r= (U8) LIMIT(er+ir, 0, 255), g=(U8) LIMIT(eg+ig, 0, 255), b=(U8) LIMIT(eb+ib, 0, 255);
		return RGBVal (this);
	}
	RGBVal operator -= (RGBVal& pal)
	{
		long er = pal.r, ir = r;// store in a long for addition below. remember that a 
		//U8 wraps around at 255 so
		// any addition involving large numbers ruins your day
		long eg = pal.g, ig = g;
		long eb = pal.b, ib = b;
		// limit is a macro defined above
		r= (U8) LIMIT(ir-er, 0, 255), g=(U8) LIMIT(ig-eg, 0, 255), b=(U8) LIMIT(ib-eb, 0, 255);
		return RGBVal (this);
	}
	RGBVal operator += (int amount)// range 1-15 is best, this is RGB so more is possible
	{
		long ir = r, ig = g, ib = b;
		// limit is a macro defined above
		r= (U8) LIMIT(ir+amount, 0, 255), g=(U8) LIMIT(ig+amount, 0, 255), b=(U8) LIMIT(ib+amount, 0, 255);
		return RGBVal (this);
	}
	RGBVal operator -= (int amount)// range 1-15 is best, this is RGB so more is possible
	{
		long ir = r, ig = g, ib = b;
		// limit is a macro defined above
		r= (U8) LIMIT(ir-amount, 0, 255), g=(U8) LIMIT(ig-amount, 0, 255), b=(U8) LIMIT(ib-amount, 0, 255);
		return RGBVal (this);
	}
	RGBVal operator + (RGBVal& pal)// used for col = c1 + c2;
	{
		long er = pal.r, ir = r;// store in a long for addition below. remember that a 
		//U8 wraps around at 255 so
		// any addition involving large numbers ruins your day
		long eg = pal.g, ig = g;
		long eb = pal.b, ib = b;
		// limit is a macro defined above
		U8 tr= (U8) LIMIT(er+ir, 0, 255), tg=(U8) LIMIT(eg+ig, 0, 255), tb=(U8) LIMIT(eb+ib, 0, 255);
		return RGBVal (tr, tg, tb);
	}
	RGBVal operator - (RGBVal& pal)// used for col = c1 - c2;
	{
		long er = pal.r, ir = r;// store in a long for addition below. remember that a 
		//U8 wraps around at 255 so
		// any addition involving large numbers ruins your day
		long eg = pal.g, ig = g;
		long eb = pal.b, ib = b;
		// limit is a macro defined above
		U8 tr= (U8) LIMIT(ir-er, 0, 255), tg=(U8) LIMIT(ig-eg, 0, 255), tb=(U8) LIMIT(ib-eb, 0, 255);
		return RGBVal (tr, tg, tb);
	}
	RGBVal operator ++ ()
	{
		long ir = r, ig = g, ib = b;
		// limit is a macro defined above
		r= (U8) LIMIT(ir+1, 0, 255), g=(U8) LIMIT(ig+1, 0, 255), b=(U8) LIMIT(ib+1, 0, 255);
		return RGBVal (this);
	}
	RGBVal operator -- ()// used for col = c1 - c2;
	{
		long ir = r, ig = g, ib = b;
		// limit is a macro defined above
		r= (U8) LIMIT(ir-1, 0, 255), g=(U8) LIMIT(ig-1, 0, 255), b=(U8) LIMIT(ib-1, 0, 255);
		return RGBVal (this);
	}
	//*******************
    void   SetVal (COLOR c)
    {
        switch (c)
        {
            case RED:
                r = 255, g = 0, b = 0;
            break;

            case FUCHSIA:
                r = 255, g = 0, b = 255;
            break;

            case BLUE:
                r = 0, g = 0, b = 255;
            break;

            case CYAN:
                r = 0, g = 255, b = 255;
            break;

            case GREEN:
                r = 0, g = 255, b = 0;
            break;

            case YELLOW:
                r = 255, g = 255, b = 0;
            break;

			case WHITE:
				r = 255, g = 255, b = 255;
			break;

			case GRAY:
				r = 127, g = 127, b = 127;
			break;

			default:// BLACK
				r = 0, g = 0, b = 0;// black
        }
    }
}RGBVal, *RGBptr;

			//*********************************
			//*********************************

struct RGBfloat
{
    float r, g, b;
    RGBfloat (){r = 0.0F, g = 0.0F, b = 0.0F;}
    RGBfloat ( RGBptr ptr )
    {
        r = (float)(ptr->r)/255;
        g = (float)(ptr->g)/255;
        b = (float)(ptr->b)/255;
    }
    void ConvertToRGB (  RGBptr ptr )
    {
        ptr->r = (U8)(r*255);
        ptr->g = (U8)(g*255);
        ptr->b = (U8)(b*255);
    }
};

struct HSVfloat
{
    float h, s, v;
    HSVfloat () {h = 0.0F, s = 1.0F, v = 1.0F;}
    HSVfloat (float th, float ts, float tv)
    {
        h = th, s = ts, v = tv;
    }
};
            //*********************************
            //*********************************
 

typedef void (* FUNC_VOID ) (void);
typedef void (* FUNC_CHARptr ) (char*);
typedef void (* FUNC_WORDptr ) (short*);
typedef void (* FUNC_INTptr ) (int*);

			//*********************************
			//*********************************

#ifdef	DEFINENULL // corrects for null definition
#undef  NULL 
#endif

#endif

