#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <errno.h>
#include "utils.h"
#include "globals.h"

void
output(float x, float y, char *format,...)
{
  va_list args;
  char buffer[200], *p;

  va_start(args, format);
  vsprintf(buffer, format, args);
  va_end(args);
  glPushMatrix();
  glTranslatef(x, y, 0);
  for (p = buffer; *p; p++)
    glutStrokeCharacter(GLUT_STROKE_ROMAN, *p);
  glPopMatrix();
}

void
abort(const char *msg)
{
  perror(msg);
  exit(-1);
}

FILE* debugf_ = 0;

void
debug(const char *msg)
{
  if (debugf_ == 0) {
    debugf_ = fopen("debug.out", "w");
  }
  fprintf(debugf_, msg);
  fflush(debugf_);
}
